<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__seller_bank_account')]
#[ORM\Entity]
class SellerBankAccount
{
	use TId;

	#[ORM\ManyToOne(targetEntity: Seller::class, inversedBy: 'bankAccounts')]
	#[ORM\JoinColumn(name: 'seller_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	private Seller $seller;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $bankName = null;

	#[ORM\Column(name: 'number_part1', type: Types::STRING, nullable: true)]
	public ?string $numberPart1 = null;

	#[ORM\Column(name: 'number_part2', type: Types::STRING, nullable: true)]
	public ?string $numberPart2 = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $swift = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $iban = null;

	#[ORM\Column(type: Types::STRING, nullable: false, options: ['default' => 'czk'])]
	public string $currencyCode = 'czk';

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $note = null;

	public function __construct(Seller $seller)
	{
		$this->seller = $seller;
	}

	public function getSeller(): Seller { return $this->seller; }

}
