<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Event;

use stdClass;
use Symfony\Contracts\EventDispatcher\Event;

class ProductsFeedEvent extends Event
{
	public string $outputFormat;
	/** @var array<stdClass|false|string> */
	public array   $data;
	public ?string $lang      = null;
	public ?string $siteIdent = null;

	public function __construct(array &$data, public ?string $customerName, string $outputFormat = 'json')
	{
		$this->data         = &$data;
		$this->outputFormat = &$outputFormat;
	}

}
