<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use function str_starts_with;

class DocumentsHelper
{
	public static function isSecured(string $file): bool { return str_starts_with($file, '/secured'); }

	public static function getFullPath(string $file): string
	{
		return (self::isSecured($file) ? APP_DIR : WWW_DIR) . $file;
	}
}
