<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

class FilterHelper
{
	final public const URL_KEY = 'productsFilter-filter';

	public static function filterUrlArrayToSimpleArray(array $data): array
	{
		$result = [];

		if (isset($data[self::URL_KEY])) {
			$data = $data[self::URL_KEY];
		}

		foreach ($data['ff'] ?? [] as $k => $v) {
			$result['features'][$k] = explode('|', (string) $v);
		}
		if ($data['fm']) {
			$result['manufacturers'] = explode('|', (string) $data['fm'][0]);
		}

		return $result;
	}

	public static function simpleArrayToFilterUrlArray(array $data): array
	{
		$result = [];

		foreach ($data['features'] as $k => $vals) {
			if (!$vals) {
				continue;
			}

			$result['ff'][$k] = implode('|', $vals);
		}

		if ($data['manufacturers']) {
			$result['fm'][] = implode('|', $data['manufacturers']);
		}

		return [self::URL_KEY => $result];
	}

}