<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Listeners;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\DynamicFeatureProduct;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class DynamicFeatureProductListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected CacheService $cacheService,
		protected Translator   $translator,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(object $entity, PreFlushEventArgs $args): void
	{
		$this->cacheService->filterCache->clean([
			Cache::Tags => ['filters'],
		]);
	}

	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(DynamicFeatureProduct $entity, PostUpdateEventArgs|PostRemoveEventArgs $event): void
	{
		$this->cacheService->filterCache->clean([
			Cache::Tags => ['filters'],
		]);
	}

}
