<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Listeners;

use Doctrine;
use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductPriceHistory;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductPriceHistoryListener implements EventSubscriberInterface
{
	public function __construct(
		protected CacheService $cacheService,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostPersist]
	public function onPostPersist(ProductPriceHistory $entity, PostPersistEventArgs $args): void
	{
		$this->cacheService->priceCache->remove('retailPrice/' . $entity->product->getId());
	}

}
