<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use Contributte\Translation\Translator;
use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	public function __construct(
		protected bool        $allowPersooSearchPage,
		protected RouteHelper $routeHelper,
		protected Translator  $translator,
	)
	{
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('EshopCatalog:Front');
		$front[] = $this->routeHelper->createRoute('/eshopcatalog/documents/<action>[/<id>]', 'Documents:default');
		$front->addRoute('/eshopcatalog/product/<id>', 'Default:product', $front::ONE_WAY);

		if ($this->allowPersooSearchPage) {
			$front[] = $this->routeHelper->createRoute(
				sprintf('/%s/', $this->translator->translate('eshopCatalogFront.persoo.searchResultsUrl')),
				'Default:persooSearch',
			);
		}

		return $router;
	}

}
