<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Suppliers;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\Supplier;
use EshopCatalog\Model\Entities\SupplierTexts;
use EshopCatalog\AdminModule\Model\Suppliers;

class SupplierForm extends BaseControl
{
	public ?Supplier     $supplier = null;
	public SupplierTexts $supplierTexts;
	protected Suppliers  $supplierServices;

	public function __construct(
		Suppliers $suppliers
	)
	{
		$this->supplierServices = $suppliers;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addText('name', 'eshopCatalog.supplierForm.name')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'eshopCatalog.supplierForm.isPublished')->setDefaultValue(0);
		$form->addText('website', 'eshopCatalog.manufacturerForm.website')
			->setNullable()
			->setMaxLength(255);
		$form->addEditor('desc', 'eshopCatalog.supplierForm.desc')->setHeight(300);

		$form->addSaveCancelControl();

		//editace
		if ($this->supplier) {
			$form->setDefaults([
				'isPublished' => $this->supplier->isPublished,
				'name'        => $this->supplier->name,
				'desc'        => $this->supplierTexts->description,
				'website'     => $this->supplier->website,
			]);
		}

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			$supplier = $this->supplier ?? new Supplier($values->name);

			$supplier->name        = $values->name;
			$supplier->isPublished = $values->isPublished;
			$supplier->website     = $values->website ?: null;

			if (!$supplier->getSupplierText('cs')) {
				$supplier->addSupplierText('cs');
			}
			$supplier->getSupplierText('cs')->description = $values->desc;

			$this->em->persist($supplier);
			$this->em->flush();
			$form->addCustomData('supplierId', $supplier->getId());
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.supplierForm.supplierSaved');
		} catch (Exception $e) {
			$form->addError($e->getMessage());
		}
	}

	public function setSupplier(int $id): void
	{
		$this->supplier      = $this->em->getRepository(Supplier::class)->find($id);
		$this->supplierTexts = $this->em->getRepository(SupplierTexts::class)->findOneBy(['id' => $id, 'lang' => 'cs']);

		if (!$this->supplier) {
			$this->getPresenter()->error();
		}
	}

}
