<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Model\Event;

use EshopCatalog\Model\Entities\Seller;
use Symfony\Contracts\EventDispatcher\Event;
use Core\Model\UI\Form\BaseForm;

class SetSellerFormDataEvent extends Event
{
	public BaseForm $form;
	public Seller $seller;

	public function __construct(BaseForm $form, Seller $seller)
	{
		$this->form = $form;
		$this->seller = $seller;
	}

}