<?php declare(strict_types = 1);

namespace EshopCatalog\Console;

use Core\Model\Lang\Langs;
use Core\Model\Sites;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopCatalog\CronModule\Model\ProductsFeed;
use Exception;
use Contributte\Translation\Translator;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class Feed extends AbstractCommand
{
	/** @var Langs|null @inject */
	public ?Langs $langs = null;

	/** @var Translator|null @inject */
	public ?Translator $translator = null;

	/** @var ProductsFeed|null @inject */
	public ?ProductsFeed $productsFeed = null;

	/** @var Sites|null @inject */
	public ?Sites $sites = null;

	protected function configure(): void
	{
		$this->setName('eshop-catalog:feed')
			->addOption('site', null, InputOption::VALUE_REQUIRED)
			->addOption('lang', null, InputOption::VALUE_REQUIRED)
			->setDescription('Generate feed');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('GENERATE FEED');

		try {
			ini_set('memory_limit', '5G');
			Debugger::dispatch();

			$result = $this->productsFeed->getProducts();
			$output->writeln($result['count']);

			$output->writeLn('<info>[OK] - feed generated</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
