<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Spatie\SchemaOrg\ItemAvailability;

class Availability
{
	/** @var int */
	protected $id;

	/** @var string */
	protected $ident;

	/** @var string */
	protected $name;

	/** @var string */
	protected $description;

	/** @var int */
	protected $delay;

	/** @var string */
	protected $textColor;

	/** @var string */
	protected $bgColor;

	/** @var int */
	protected $canShowOnList;

	/** @var int */
	protected $canShowOnSearch;

	/** @var int */
	protected $canAddToCart;

	protected ?string $openGraphText      = null;
	public int        $warehouseOverdraft = 0;

	public function setData(array $data): void
	{
		foreach ($data as $k => $v) {
			$this->$k = $v;
		}
	}

	public function getId(): int
	{
		return $this->id;
	}

	public function getIdent(): string
	{
		return $this->ident;
	}

	public function getName(): string
	{
		return $this->name;
	}

	public function getDescription(): string
	{
		return $this->description;
	}

	public function getDelay(): int
	{
		return $this->delay;
	}

	public function getTextColor(): string
	{
		return $this->textColor;
	}

	public function getBgColor(): string
	{
		return $this->bgColor;
	}

	public function canShowOnList(): int
	{
		return $this->canShowOnList;
	}

	public function canShowOnSearch(): int
	{
		return $this->canShowOnSearch;
	}

	public function canAddToCart(): int
	{
		return $this->canAddToCart;
	}

	public function getOpenGraphText(): ?string
	{
		return $this->openGraphText;
	}

	public function getSchemaUrl(): string
	{
		switch ($this->getOpenGraphText()) {
			case 'in stock':
				return ItemAvailability::InStock;
			case 'preorder':
			case 'available for order':
				return ItemAvailability::PreOrder;
			case 'discontinued':
				return ItemAvailability::Discontinued;
			default:
				return ItemAvailability::SoldOut;
		}
	}

	public function getStyle(): string
	{
		$arr = [];

		if ($this->getTextColor()) {
			$arr[] = 'color:' . $this->getTextColor();
		}
		if ($this->getBgColor()) {
			$arr[] = 'background-color:' . $this->getBgColor();
		}

		return implode(';', $arr) . ';';
	}

}