<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class FilterLinkEvent extends Event
{
	public array   $currentFilter;
	public array   $categories;
	public string  $type;
	public string  $key;
	public string  $value;
	public ?string $result = null;

	public function __construct(
		array  $currentFilter,
		array  $categories,
		string $type,
		string $key,
		string $value
	)
	{
		$this->currentFilter = $currentFilter;
		$this->categories    = $categories;
		$this->type          = $type;
		$this->key           = $key;
		$this->value         = $value;
	}

}