<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Subscribers;

use EshopCatalog\Model\PseudoWarehouse;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopCatalog\Model\Config;
use EshopOrders\FrontModule\Model\Event\OrderEvent;

class OrderPseudoWarehouseSubscriber implements EventSubscriberInterface
{
	protected PseudoWarehouse $pseudoWarehouse;

	public function __construct(PseudoWarehouse $pseudoWarehouse)
	{
		$this->pseudoWarehouse = $pseudoWarehouse;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['orderOnSuccess', 100],
			'eshopOrders.admin.orderOnSuccess' => ['orderOnSuccess', 100],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		if (!Config::load('pseudoWarehouse')) {
			return;
		}

		$data = [];

		foreach ($event->order->getOrderItems() as $v) {
			if ($v->getProductId()) {
				$data[$v->getProductId()] = $v->getQuantity();
			}
		}

		foreach ($event->order->getGifts() as $v) {
			if (!$v->getProduct()) {
				continue;
			}
			$prodId = $v->getProduct()->getId();

			if (isset($data[$prodId])) {
				$data[$prodId] += 1;
			} else {
				$data[$prodId] = 1;
			}
		}

		$this->pseudoWarehouse->lowerQuantities($data, $event->order);
	}

}