<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

class Config extends \Core\Model\Config
{
	public static function setParams(array $params): void
	{
		parent::setParams($params);
		self::updateParams();
	}

	protected static function updateParams(): void
	{
		$params = self::$params[get_called_class()];
		$result = $params['config'];

		unset($params['config']);
		foreach ($params as $k => $v) {
			$result[$k] = $v;
		}

		self::$params[get_called_class()] = $result;
	}

}
