<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\SmartObject;

class CategoryFilterListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 */
	public function postHandler(CategoryFilter $categoryFilter, LifecycleEventArgs $event): void
	{
		$this->cacheService->clean('category', [Cache::TAGS => ['category/' . $categoryFilter->category->getId()]]);
	}

	/**
	 * @ORM\PreFlush
	 */
	public function onPreFlush(CategoryFilter $categoryFilter, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		$this->cacheService->clean('category', [Cache::TAGS => ['category/' . $categoryFilter->category->getId()]]);
	}

}