<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\Categories;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\SmartObject;

class CategoryListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 */
	public function postUpdateHandler(Category $category, LifecycleEventArgs $event): void
	{
		$this->cacheService->clean('category', [Cache::TAGS => ['categories']]);
	}

	/**
	 * @ORM\PostRemove
	 */
	public function postRemoveHandler(Category $category, LifecycleEventArgs $event): void
	{
		$tags2 = [
			Categories::CACHE_NAMESPACE,
		];

		if ($category->getParent()) {
			$tags2[] = 'category/' . $category->getParent()->getId();
		}

		$this->cacheService->clean('category', [Cache::TAGS => $tags2]);
	}

}