<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\Features;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Contributte\Translation\Translator;
use Nette\Caching\Cache;
use Nette\SmartObject;

class FeatureListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;
	protected Translator   $translator;

	public function __construct(
		CacheService $cacheService,
		Translator   $translator
	)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param Feature|object $entity
	 */
	public function onPreFlush(object $entity, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		$this->cacheService->defaultCache->clean([
			Cache::TAGS => ['features', Features::CACHE_NAMESPACE],
		]);
		$this->cacheService->filterCache->clean([
			Cache::TAGS => ['filters'],
		]);
	}

}
