<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\SmartObject;

class FeatureValueListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;
	protected Translator $translator;

	public function __construct(CacheService $cacheService, Translator $translator)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param object $entity
	 */
	public function onPreFlush($entity, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		foreach ($this->translator->getLocalesWhitelist() as $l) {
			$this->cacheService->defaultCache->remove('featureValues_' . $l);
			$this->cacheService->defaultCache->remove('featureValueTexts_' . $l);
		}

		$this->cacheService->defaultCache->remove('featureIdValues');
		$this->cacheService->defaultCache->clean([
			Cache::TAGS => ['featureValues'],
		]);
		$this->cacheService->filterCache->clean([
			Cache::TAGS => ['filters'],
		]);
	}

}