<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="eshop_catalog__feature_value_texts", indexes={@ORM\Index(name="feature_value", columns={"id", "lang"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureValueListener"})
 */
class FeatureValueTexts
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="FeatureValue", inversedBy="featureValueTexts")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private FeatureValue $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $name = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $rodM = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $rodZ = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $rodS = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $tagText = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $shortDescription = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $longDescription = null;

	public function __construct(FeatureValue $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getFeatureValue(): FeatureValue { return $this->id; }

	public function getLang(): string
	{
		return $this->lang;
	}

	public function setName(string $name): self
	{
		$this->name = Strings::truncate($name, 255, '');

		return $this;
	}

}