<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__product_in_site")
 * @ORM\Entity
 * @ORM\EntityListeners({"ProductInSiteListener"})
 */
class ProductInSite
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Product $product;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site", referencedColumnName="ident", nullable=false, onDelete="CASCADE")
	 */
	protected Site $site;

	/**
	 * @var int|bool
	 * @ORM\Column(type="smallint", nullable=false, options={"default": 0})
	 */
	protected $isActive;

	/**
	 * @ORM\ManyToOne(targetEntity="Category")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
	 */
	public ?Category $category = null;

	public function __construct(Product $product, Site $site)
	{
		$this->product  = $product;
		$this->site     = $site;
		$this->isActive = 0;
	}

	public function getProduct(): Product { return $this->product; }

	public function getSite(): Site { return $this->site; }

	/**
	 * @return bool|int
	 */
	public function isActive() { return $this->isActive; }

	public function setActive(int $active = 1): self
	{
		$this->isActive = $active;

		return $this;
	}

}