<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__vat_rate")
 * @ORM\Entity
 */
class VatRate
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	public string $name;

	/**
	 * @ORM\Column(type="smallint")
	 */
	public int $rate;

	/**
	 * @ORM\Column(type="string", length=10, nullable=true)
	 */
	public ?string $pohodaRate = null;

	public function getModifier(): float
	{
		return round($this->rate / 100 * 1, 2);
	}

}