<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use EshopCatalog\Model\IProductsOldUrlResolver;
use Nette\DI\Container;

class ProductsHelper
{
	protected Container $container;

	public function __construct(Container $container)
	{
		$this->container = $container;
	}

	public function getOldUrlResolver(): ?IProductsOldUrlResolver
	{
		$resolver = $this->container->getByType(IProductsOldUrlResolver::class, false);

		return $resolver ?: null;
	}

	public static function processPrice(float $price, int $vat): float
	{
		return round($price * (($vat / 100) + 1), 2);
	}

}