<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

class ZboziExportEnums
{
	public const WARRANTY = 'warranty';

	public static array $list = [
		self::WARRANTY => [
			'title' => 'eshopCatalog.zboziType.warranty',
		],
	];

	public static function getListForSelect(): array
	{
		$arr = [];

		foreach (self::$list as $k => $v) {
			$arr[$k] = $v['title'];
		}

		return $arr;
	}

	public static function getListItemsForSelect(): array
	{
		$arr = [];

		foreach (self::$list as $k => $v) {
			if (!isset($v['items'])) {
				continue;
			}

			foreach ($v['items'] as $vk => $vv) {
				$arr[$k][$vk] = $vv;
			}
		}

		return $arr;
	}
}
