<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use Contributte\Translation\Translator;
use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;
use Nette\Routing\Router;

class RouterFactory
{
	protected RouteHelper $routeHelper;
	protected Translator  $translator;
	protected bool        $allowPersooSearchPage = false;

	public function __construct(
		bool        $allowPersooSearchPage,
		RouteHelper $routeHelper,
		Translator  $translator
	)
	{
		$this->allowPersooSearchPage = $allowPersooSearchPage;
		$this->routeHelper           = $routeHelper;
		$this->translator            = $translator;
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('EshopCatalog:Front');
		$front[] = $this->routeHelper->createRoute('/eshopcatalog/documents/<action>[/<id>]', 'Documents:default');
		$front[] = $this->routeHelper->createRoute('/eshopcatalog/product/<id>', 'Default:product', Router::ONE_WAY);

		if ($this->allowPersooSearchPage) {
			$front[] = $this->routeHelper->createRoute(
				sprintf('/%s/', $this->translator->translate('eshopCatalogFront.persoo.searchResultsUrl')), 'Default:persooSearch');
		}

		return $router;
	}

}
