<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Translation\Translator;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\FrontModule\Model\ProductsFacade;

class CategoryWithProducts extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogCategoryWithProducts';

	protected Products $productsService;
	protected ProductsFacade $productsFacade;
	protected Categories $categoriesService;
	protected Translator $translator;

	public function __construct(Products $products, ProductsFacade $productsFacade, Categories $categories, Translator $translator)
	{
		$this->productsService   = $products;
		$this->productsFacade    = $productsFacade;
		$this->categoriesService = $categories;
		$this->translator        = $translator;
	}

	/**
	 * @inheritDoc
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (!isset($params['categoryId']) || !isset($params['limit'])) {
			$container = $formContainer->addContainer($params['name']);
		} else {
			return;
		}

		if (!isset($params['categoryId'])) {
			$opts = ['' => ''];
			foreach ($this->categoriesService->getCategories() as $cat) {
				$prefix = '';
				for ($i = 1; $i < $cat->lvl; $i++) {
					$prefix .= '---';
				}
				$opts[$cat->id] = trim($prefix . ' ' . $cat->name);
			}
			$container->addSelect('categoryId', 'eshopCatalog.templateTextFields.categoryId', $opts);
		}

		if (!isset($params['limit'])) {
			$container->addText('limit', 'eshopCatalog.templateTextFields.limit')
				->setHtmlType('number')
				->setValue(6);
		}
	}

	public function render($params)
	{
		$default              = $this->getDefault();
		$params['categoryId'] = $params['categoryId'] ?: $default['categoryId'] ?? null;
		$params['limit']      = $params['limit'] ?: $default['limit'] ?? null;

		if (!isset($params['toVar'])) {
			bdump('Need variable for output');

			return [];
		}
		if (!isset($params['categoryId'])) {
			bdump('Need categoryId for output');

			return [];
		}

		$ids = $this->productsService->getProductsIdInCategory((int) $params['categoryId'], 0, $params['limit'] ?? null);

		return [
			'category' => $this->categoriesService->get((int) $params['categoryId']),
			'products' => $ids ? $this->productsFacade->getProducts($ids) : [],
		];
	}

}