<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\FrontModule\Model\Dao\Category;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\Model\Config;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Utils\ArrayHash;
use Nette\Utils\Paginator;
use Tracy\Debugger;

/**
 * Class Navigation
 * @package EshopCatalog\FrontModule\Components
 */
class Navigation extends BaseControl
{
	/** @var DaoNavigationItem[] */
	protected $navs;

	/** @var string */
	protected $navigationType;

	/** @var Navigations */
	protected $navigationsService;

	/** @var Categories */
	protected $categoriesService;

	/** @var CacheService */
	protected $cacheService;

	/** @var bool */
	protected $cacheCleaned = false;

	/** @var array */
	protected $cByParent;

	/** @var Category */
	protected $currentCategory;

	public function __construct(Navigations $navigations, Categories $categories, CacheService $cacheService)
	{
		$this->navigationsService = $navigations;
		$this->categoriesService  = $categories;
		$this->cacheService       = $cacheService;
	}

	protected function attached($presenter): void
	{
		parent::attached($presenter);
	}

	public function render($template = 'Default'): void
	{
		$this->template->navs            = $this->getNavs();
		$this->template->categories      = $this->categoriesService->getCategories();
		$this->template->currentCategory = $this->categoriesService->get((int) $this->getPresenter()->getParameter('id'));

		$this->template->render($this->getTemplateFile($template));
	}
	/*******************************************************************************************************************
	 * ============================== Get / Set
	 */

	/**
	 * @return DaoNavigationItem[]
	 */
	public function getNavs(): array
	{
		if (!$this->navs) {
			foreach ($this->navigationsService->getPublishedDaoNavigationStructure()[$this->navigationType] ?? [] as $nav) {
				$this->navs[$nav->id] = $nav;
			}
		}

		return $this->navs ?: [];
	}

	/**
	 * @param string $type
	 *
	 * @return $this
	 */
	public function setNavigationType($type): self
	{
		$this->navigationType = $type;

		return $this;
	}
}
