import {checkMedia, scrollTo} from "core/js/utils/utilities";
import noUiSlider             from "nouislider";
import {FormatMoney}          from "core/js/utils/formatMoney";
import {slideDown, slideUp}   from "es6-slide-up-down";

/**
 * Automatické přesměrování při změně počtu ks na stránku
 */
document.addEventListener('change', e => {
	if (e.target.id === 'items-per-page') {
		window.location.href = e.target.options[e.target.selectedIndex].dataset.link;
		e.preventDefault();
	}
});

/**
 * Mobil - titulek filtru
 */
const initFilterTitleToggle = () => {
	const itemsFilterTitle = document.querySelector('.filters__main-title');

	if (itemsFilterTitle) {
		if (itemsFilterTitle.filterTitleToogleInit === true)
			return;

		itemsFilterTitle.filterTitleToogleInit = true;

		itemsFilterTitle.addEventListener('click', e => {
			itemsFilterTitle.classList.toggle('active');
		});
	}
};

initFilterTitleToggle();
global.naja.addEventListener('complete', e => {
	initFilterTitleToggle();
});

/**
 * TODO nejak vylepsit aby nebylo treba js
 * Mobil - přesunutí popisu kategorie před filtraci
 */
document.addEventListener('DOMContentLoaded', () => {
	const categoryIntro  = document.querySelector('.category .category-intro');
	const productsFilter = document.querySelector('.col-products-filter');
	let mobileSize       = checkMedia(document.body.dataset.responsiveBarThreshold);
	if (categoryIntro && productsFilter && mobileSize) {
		categoryIntro.remove();
		productsFilter.prepend(categoryIntro);
	}
});

/**
 * Price slider
 */
const initPriceRange = () => {
	let slider = document.getElementById('price-slider');

	if (!slider || slider.classList.contains('init'))
		return;

	slider.classList.add('init');

	const min   = parseFloat(slider.dataset.min).toFixed(2);
	const max   = parseFloat(slider.dataset.max).toFixed(2);
	const start = parseFloat(slider.dataset.start).toFixed(2);
	const end   = parseFloat(slider.dataset.end).toFixed(2);

	const parent = slider.parentNode;
	const input0 = parent.querySelector('#input-with-keypress-0');
	const input1 = parent.querySelector('#input-with-keypress-1');
	const inputs = [input0, input1];

	noUiSlider.create(slider, {
		start   : [min, max],
		range   : {
			min: parseFloat(start),
			max: parseFloat(end),
		},
		tooltips: [true, true],
		connect : true,
		format  : {
			to  : function (value) {
				return FormatMoney.format(Math.round(value), 0) + ' ' + slider.dataset.currency;
			},
			from: function (value) {
				return Number(value.replace(',-', ''));
			}
		}
	});

	slider.noUiSlider.on('change', function (values, handle, unencoded, tap, positions) {
		let min  = parseFloat(unencoded[0]).toFixed(2);
		let max  = parseFloat(unencoded[1]).toFixed(2);
		let link = slider.dataset.updateLink;

		let urlParamsBase = link.split('?');
		let urlParams     = urlParamsBase[1].split('&');

		document.querySelector('[name="priceRange[min]"]').value = min;
		document.querySelector('[name="priceRange[max]"]').value = max;

		if (start == min) {
			let k = urlParams.findIndex(a => a == 'productsFilter-min=__min__');
			if (k !== -1)
				delete urlParams[k];
		}
		if (end == max) {
			let k = urlParams.findIndex(a => a == 'productsFilter-max=__max__');
			if (k !== -1)
				delete urlParams[k];
		}

		urlParams = urlParams.filter(Boolean);

		link = urlParamsBase[0] + (urlParams.length ? '?' : '') + urlParams.join('&');
		link = link.replace('__min__', min).replace('__max__', max);

		if (checkMedia(768, 'min')) {
			global.naja.makeRequest('get', link, [], {
				history: true,
			});
		}

	});

	slider.noUiSlider.on('update', function (values, handle, rawValue, bool, percentageValue) {
		inputs[handle].innerHTML = values[handle];
	});
};


document.addEventListener('DOMContentLoaded', () => {
	const mobileSizeForFilter = checkMedia(document.body.dataset.responsiveThresholdEshopFilter);

	initPriceRange();

	global.naja.addEventListener('complete', e => {
		initPriceRange();
	});

	document.addEventListener('click', e => {
		const target = e.target;
		let el       = null;

		/**
		 * Zobrazení/Skrytí dalších položek filtru
		 */
		el = target.closest('[data-show-more]');
		if (el !== null) {
			e.preventDefault();

			const targetEl = el.parentNode.querySelector('[data-hidden-content]');
			if (!targetEl.classList.contains('active')) {
				targetEl.style.display = "block";
				targetEl.classList.add('active');
				el.classList.add('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.hide;
			} else {
				targetEl.style.display = "none";
				targetEl.classList.remove('active');
				el.classList.remove('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.show;
			}

			return;
		}

		/**
		 * Skryvani a odkryvani filtru na responzivni verzi
		 */
		el = target.closest('[data-show-filter]');
		if (el !== null) {
			e.preventDefault();

			const id            = el.dataset.showFilter;
			const parent        = el.parentNode;
			const targetElement = parent.querySelector(`[data-filter-group="${id}"]`);
			if (!targetElement.classList.contains('active')) {
				slideDown(targetElement);
				targetElement.classList.add('active');
				targetElement.closest('.filters__row').classList.add('active');
			} else {
				slideUp(targetElement);
				targetElement.classList.remove('active');
				targetElement.closest('.filters__row').classList.remove('active');
			}

			return;
		}

		/**
		 * Vypnuti okamziteho filtrovani na mobilu
		 */
		el = target.closest('.filters__filter-val');
		if (el !== null && mobileSizeForFilter) {
			e.preventDefault();

			let input     = el.querySelector('input');
			input.checked = !input.checked;
			input.dispatchEvent(new Event('change'));

			return;
		}

		/**
		 * Potvrzení filtrování mobilu
		 */
		el = target.closest('.filters__confirm-btn');
		if (el !== null && mobileSizeForFilter) {
			e.preventDefault();
			const eshopProductsFilterForm = document.getElementById('eshop-products-filter');

			let productsList         = document.querySelector('.product-list');
			let productsListBounding = productsList ? productsList.getBoundingClientRect() : null;

			global.naja.makeRequest('post', eshopProductsFilterForm.action, new FormData(eshopProductsFilterForm), {
				history: false,
			}).then((response) => {
				window.history.pushState('', '', response.url);

				if (productsListBounding) {
					let bodyRect = document.body.getBoundingClientRect();
					scrollTo(productsListBounding.top - bodyRect.top - 100, 200);
				}
			});

			return;
		}

		if (!mobileSizeForFilter) {
			el = target.closest('.filters__filter-val');
			if (el !== null) {
				e.preventDefault();

				global.naja.makeRequest('GET', el.href, {}, {
					history: true,
				});

				return;
			}
		}

		/**
		 * Scroll kategorie dlouhý text
		 */
		el = target.closest('[data-scroll-to]');
		if (el !== null) {
			const scrollTarget = document.querySelector(el.dataset.scrollTo);
			console.log(scrollTarget);
			console.log(scrollTarget.getBoundingClientRect().top);

			if (scrollTarget) {
				scrollTo(scrollTarget.getBoundingClientRect().top)
			}
		}
	});

	if (mobileSizeForFilter) {
		const eshopProductsFilterForm = document.getElementById('eshop-products-filter');

		if (eshopProductsFilterForm) {
			eshopProductsFilterForm.addEventListener('submit', e => {
				document.querySelector('.filters__confirm-btn').dispatchEvent(new Event('click'));
			});
		}
	} else {
		const filtersWrap = document.querySelector('.filters__all-wrap');

		if (filtersWrap)
			global.naja.uiHandler.bindUI(filtersWrap);
	}
});
