<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\FormContainers\RelatedProductContainer;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\Model\Helpers\VariantsHelper;
use Nette\Application\IPresenter;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;

class RelatedProductsForm extends BaseControl
{
	protected RelatedProductContainer $relatedProductContainer;

	protected Products $products;

	protected VariantsHelper $variantsHelper;

	public function __construct(RelatedProductContainer $relatedProductContainer, Products $products,
	                            VariantsHelper $variantsHelper)
	{
		$this->relatedProductContainer = $relatedProductContainer;
		$this->products                = $products;
		$this->variantsHelper          = $variantsHelper;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->addComponent($this->relatedProductContainer->getContainer(), 'relatedProducts');

		$this->monitor(IPresenter::class, function(AbstractPresenter $presenter) use ($form) {
			$form['relatedProducts']['product']->getControlPrototype()->setAttribute('data-link', $presenter->link(':EshopCatalog:Cron:Products:loadAll'));
		});
		$form->addCheckbox('applyToVariants', 'eshopCatalog.productFeature.applyToVariants');

		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm  $form
	 * @param ArrayHash $values
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$productsIds = explode('-', (string)$this->presenter->getParameter('ids'));

		if ($values->applyToVariants ?? false)
			$productsIds = array_merge($productsIds, ...$this->variantsHelper->getProductVariants($productsIds));

		if ($productsIds) {
			foreach ($productsIds as $productId) {
				if (!$product = $this->products->get((int) $productId)) {
					continue;
				}
				$this->relatedProductContainer->saveData($form->getHttpData(), $product);
				$this->em->persist($product);
			}

			$this->em->flush();
			$this->getPresenter()->flashMessageSuccess('default.saved');
		}
	}

	/**
	 * @param mixed $ids
	 */
	public function setProducts($ids): void
	{
	}

}
