<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\ProductPriceLevelCountry;

/**
 * @method ProductPriceLevelCountry|null|object = getReference($id)
 * @method ProductPriceLevelCountry[]|null getAll()
 */
class ProductPriceLevelCountries extends BaseEntityService
{
	protected $entityClass = ProductPriceLevelCountry::class;

	public function get(int $productId, int $groupId, string $country)
	{
		return $this->getEr()->findOneBy(['product' => $productId, 'group' => $groupId, 'country' => $country]);
	}
}
