<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\ProductVideo;

class ProductVideos extends BaseEntityService
{
	protected $entityClass = ProductVideo::class;

	/**
	 * @return ProductVideo[]
	 */
	public function getByProduct(int $productId): array
	{
		$qb = $this->getEr()->createQueryBuilder('pv');
		return $qb->join('pv.product', 'p')
				  ->where('p.id = :pid')
				  ->setParameter('pid', $productId)
				  ->getQuery()->getResult();
	}
}