<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\FilterService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\SmartObject;

class FeatureProductListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var CacheService */
	protected $cacheService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(CacheService $cacheService, ITranslator $translator)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param object             $entity
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($entity, $args)
	{
	}

	/**
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param Entity             $entity
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postHandler($entity, LifecycleEventArgs $event)
	{
	}
}
