document.addEventListener('DOMContentLoaded', () => {
	initFeatures();
	initVariables();
});

const initFeatures = () => {
	const featureSearchInput = document.getElementById('features-search__input');
	const featureValuesList  = {};
	const featuresSearchList = featureSearchInput.nextElementSibling.querySelector('.checkbox-list-input').children;

	// Vytahnuti vsech vlastnosti
	document.querySelectorAll('.feature-values-list__feature').forEach(el => {
		featureValuesList[el.dataset.id] = el;
	});

	// Prevent odeslani entrem všechny inputy
	document.getElementById('snippet-productForm-form').querySelectorAll('input').forEach(el => {
		el.addEventListener('keypress', e => {
			if (e.keyCode == 13) {

				// Povoleníé přidání vlastnosti entrem
				if (el.dataset.featureCustom) {
					let featureId = el.dataset.featureCustom;
					let link      = el.dataset.link.replace('__id__', featureId).replace('__val__', el.value);
					global.naja.makeRequest('get', link, [], {
						history: false,
					}).then(response => {
						let select = featureValuesList[featureId].querySelector('select');
						if (response.data.created) {
							let option   = document.createElement('option');
							option.value = response.data.id;
							option.text  = response.data.name;
							select.add(option);
						}

						select.value = response.data.id;
						el.value     = '';
					});
				}

				e.preventDefault();
				return false;
			}
		});
	});

	// Skryti / zobrayeni vlasntosti
	featureSearchInput.nextElementSibling.querySelectorAll('input[type=checkbox]').forEach(el => {
		el.addEventListener('change', e => {
			let target = featureValuesList[el.value];
			if (target)
				target.classList.toggle('hidden');
		});
	});

	// Hledani ve vlastnostech
	featureSearchInput.addEventListener('keyup', e => {
		let search = featureSearchInput.value;

		if (search.length < 2) {
			featuresSearchList.forEach(el => {
				el.style.display = 'block';
			});
		} else {
			let regEx = new RegExp(featureSearchInput.value, 'i');
			featuresSearchList.forEach(el => {
				if (el.innerText.match(regEx))
					el.style.display = 'block';
				else
					el.style.display = 'none';
			});
		}
	});

	const setAsVariantForBtn = document.getElementById('setAsVariantForBtn');
	if (setAsVariantForBtn) {
		setAsVariantForBtn.addEventListener('click', e => {
			e.preventDefault();

			let input = setAsVariantForBtn.nextElementSibling;
			let value = input.value;

			if (!value)
				input.classList.add('frm__input-error');
			else {
				input.classList.remove('frm__input-error');

				global.naja.makeRequest('post', setAsVariantForBtn.href, {
					productId: value,
				}, {
					history      : false,
					forceRedirect: true,
				});
			}

			return false;
		});
	}
};

const initVariables = () => {
	document.querySelectorAll('#snippet-productForm-form .variant-use-bool').forEach(el => {
		el.querySelector('input').addEventListener('change', e => {
			el.classList.toggle('active');
		});
	});
};
