<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\VatRates;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\InvalidArgumentException;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\VatRate;
use EshopCatalog\AdminModule\Model\VatRates;

class VatRateForm extends BaseControl
{
	/** @var VatRate */
	public $vatRate;

	/** @var int @persistent */
	public $id;

	/** @var VatRates */
	protected $vatRateServices;

	public function __construct(VatRates $vatRates)
	{
		$this->vatRateServices = $vatRates;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('name', 'eshopCatalog.vatRateForm.name')->setRequired()->setMaxLength(255);
		$form->addInteger('rate', 'eshopCatalog.vatRateForm.rate')->setRequired();

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			$vatRate = $this->id ? $this->vatRateServices->getReference($this->id) : new VatRate();

			$vatRate->name = $values->name;
			$vatRate->rate = $values->rate;

			$this->em->persist($vatRate);
			$this->em->flush();
			$form->addCustomData('vatRateId', $vatRate->getId());
			$this->getPresenter()->flashMessageSuccess('default.saved');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}

		return true;
	}

	public function setVatRate(int $id): void
	{
		$this->id      = $id;
		$this->vatRate = $this->em->getRepository(VatRate::class)->find($id);

		if (!$this->vatRate)
			throw new InvalidArgumentException();

		$this['form']->setDefaults([
			'name' => $this->vatRate->name,
			'rate' => $this->vatRate->rate,
		]);
	}
}
