<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\FeatureValue;
use Nette\Caching\Cache;

/**
 * Class FeatureValues
 * @package EshopCatalog\AdminModule\Model
 *
 * @method FeatureValue|null|object = getReference($id)
 * @method FeatureValue[]|null getAll()
 * @method FeatureValue|null get($id)
 */
class FeatureValues extends BaseEntityService
{
	use TPublish;
	use TPosition;

	/** @var CacheService @inject */
	public $cacheService;

	protected $entityClass = FeatureValue::class;

	/**
	 * @param int $id
	 * @param int $position
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition((int) $position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function mergeAll()
	{
		$delete = [];
		foreach ($this->getEr()->createQueryBuilder('fv')->select('fv.id')
			         ->leftJoin('fv.featureValueTexts', 'fvt')->where('fvt IS NULL')->getQuery()->getArrayResult() as $row)
			$delete[] = $row['id'];

		foreach (array_chunk($delete, 200) as $chunk)
			$this->em->createQuery('DELETE FROM ' . $this->entityClass . ' fv WHERE fv.id IN (:id)')->setParameter('id', $chunk)->execute();
		$delete = null;

		$fks = [];
		foreach ($this->em->getConnection()->fetchAll("
				SELECT *
					FROM information_schema.KEY_COLUMN_USAGE
					WHERE
  						REFERENCED_TABLE_NAME = 'eshop_catalog__feature_value'
  						AND REFERENCED_COLUMN_NAME = 'id'
  						AND CONSTRAINT_SCHEMA = '{$this->em->getConnection()->getDatabase()}'") as $tmp) {
			if ($tmp['TABLE_NAME'] == 'eshop_catalog__feature_value_texts')
				continue;

			$fks[] = $tmp;
		}

		//TODO lang
		foreach ($this->getEr()->createQueryBuilder('fv')->select('fvt.name, count(fv.id), IDENTITY(fv.feature) as feature')
			         ->join('fv.featureValueTexts', 'fvt', 'WITH', 'fvt.lang = \'cs\'')
			         ->groupBy('feature, fvt.name')->having('count(fv.id) > 1')
			         ->getQuery()->getArrayResult() as $duplicate) {

			$ids = [];
			foreach ($this->getEr()->createQueryBuilder('fv')->select('fv.id')
				         ->where('fvt.name = :name')->setParameter('name', $duplicate['name'])
				         ->andWhere('fv.feature = :feature')->setParameter('feature', $duplicate['feature'])
				         ->join('fv.featureValueTexts', 'fvt', 'WITH', 'fvt.lang = \'cs\'')
				         ->getQuery()->getArrayResult() as $tmp)
				$ids[] = $tmp['id'];

			$first = array_shift($ids);

			foreach ($fks as $fk) {
				$this->em->getConnection()->update($fk['TABLE_NAME'], [$fk['COLUMN_NAME'] => $first], [$fk['COLUMN_NAME'] => $ids]);
			}

			$this->em->createQuery('DELETE FROM ' . $this->entityClass . ' fv WHERE fv.id IN(:id)')->setParameter('id', $ids)->execute();
		}

		$this->cacheService->defaultCache->clean([Cache::TAGS => ['features']]);
	}

	/**
	 * @return bool
	 * @throws \Doctrine\DBAL\DBALException
	 */
	public function repairPositions($feature = null)
	{
		$items = $this->getEr()->createQueryBuilder('fv')->select('fv.id, fv.position, IDENTITY(fv.feature) as feature')
			->orderBy('feature')->addOrderBy('fv.position')->addOrderBy('fv.id');

		if ($feature)
			$items->andWhere('fv.feature = :feature')->setParameter('feature', $feature);

		$items     = $items->getQuery()->getArrayResult();
		$lastGroup = null;
		$i         = 0;
		foreach ($items as $item) {
			$this->em->getConnection()
				->prepare('UPDATE ' . $this->em->getClassMetadata($this->entityClass)->getTableName() . ' SET position = :position WHERE id = :id')
				->execute(['position' => $i, 'id' => $item['id']]);
			$i++;

			if ($lastGroup != $item['feature'] && $lastGroup !== null)
				$i = 0;

			$lastGroup = $item['feature'];
		}

		return true;
	}
}
