<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\ProductDocument;

class ProductDocuments extends BaseEntityService
{
	protected $entityClass = ProductDocument::class;

	/**
	 * @param int $productId
	 * @return ProductDocument
	 */
	public function getByProduct(int $productId): array
	{
		$qb = $this->getEr()->createQueryBuilder('pd');
		return $qb->join('pd.product', 'p')
				  ->where('p.id = :pid')
				  ->setParameter('pid', $productId)
				  ->getQuery()->getResult();
	}

}