<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\Model\Entities\Seller;
use EshopCatalog\Model\Entities\SellerInSite;

/**
 * Class Sellers
 * @package EshopCatalog\AdminModule\Model
 *
 * @method Seller|null|object = getReference($id)
 * @method Seller[]|null getAll()
 * @method Seller|null get($id)
 */
class Sellers extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Seller::class;

	public function getSitesInUse(): array
	{
		$result = [];

		foreach ($this->em->getRepository(SellerInSite::class)->createQueryBuilder('s')
			         ->select('seller.id as sellerId, IDENTITY(s.site) as site, seller.title as sellerName')
			         ->innerJoin('s.seller', 'seller')
			         ->getQuery()->getArrayResult() as $row) {
			$result[$row['site']] = $row;
		}

		return $result;
	}
}
