<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use Core\AdminModule\Components\IDataFormFactory;
use Core\AdminModule\Components\SettingsForm;
use EshopCatalog\AdminModule\Components\Availability\AvailabilityGrid;
use EshopCatalog\AdminModule\Components\Availability\IAvailabilityGridFactory;
use EshopCatalog\AdminModule\Components\Seller\ISellersGridFactory;
use EshopCatalog\AdminModule\Components\Seller\SellersGrid;
use EshopCatalog\AdminModule\Components\VatRates\IVatRatesGridFactory;
use EshopCatalog\AdminModule\Components\VatRates\VatRatesGrid;

class SettingsPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('eshopCatalog.title.settings', 'fas fa-cogs');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addVatRate',
				'link'  => $this->link('vatRatesGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
			[
				'title' => 'eshopCatalog.menu.addAvailability',
				'link'  => $this->link('availabilityGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
			[
				'title' => 'eshopCatalog.menu.addSeller',
				'link'  => $this->link('sellersGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentVatRatesGrid(IVatRatesGridFactory $factory): VatRatesGrid
	{
		return $factory->create();
	}

	protected function createComponentAvailabilityGrid(IAvailabilityGridFactory $factory): AvailabilityGrid
	{
		return $factory->create();
	}

	protected function createComponentSellersGrid(ISellersGridFactory $factory): SellersGrid
	{
		return $factory->create();
	}

	protected function createComponentSettingsForm(IDataFormFactory $factory): SettingsForm
	{
		return $factory->create('eshopCatalog');
	}
}

