<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Presenters;

use Core\Model\Sites;
use EshopCatalog\FrontModule\Model\ExportFacade;
use Nette\Application\Responses\TextResponse;

class ExportPresenter extends BasePresenter
{
	protected ExportFacade $exportFacade;

	protected Sites $sites;

	protected array $fileHandles = [];

	public function __construct(ExportFacade $exportFacade, Sites $sites)
	{
		$this->exportFacade = $exportFacade;
		$this->sites        = $sites;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionPorovnavace()
	{
		$params = $this->getParameters();
		$types  = $params['type'] ?? null;
		$site   = $params['site'] ? $this->sites->getSites()[$params['site']] : $this->sites->getCurrentSite();

		if ($params['lang'] && isset($site->getDomains()[$params['lang']]))
			$domain = $site->getDomains()[$params['lang']];
		else
			$domain = $site->getCurrentDomain();

		if ($types && $site) {
			set_time_limit(600);

			$this->exportFacade->generateExport($types, $site, $domain);
			$msg = 'ok';
		} else {
			$msg = 'error';
		}

		$response = new TextResponse($msg);
		$this->sendResponse($response);
	}
}
