<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Model\UI\BaseControl;
use EshopCatalog\FrontModule\Model\Dao\Product;
use Nette\Application\UI\Multiplier;

class VariantsPopup extends BaseControl
{
	/** @var Product */
	protected $product;

	/** @var ICartAddFormFactory */
	protected $cartAddFormFactory;

	public function __construct(Product $product,
	                            ICartAddFormFactory $cartAddFormFactory)
	{
		$this->product            = $product;
		$this->cartAddFormFactory = $cartAddFormFactory;
	}

	public function render(): void
	{
		$this->template->product = $this->product;
		$this->template->render($this->getTemplateFile());
	}

	public function handleShowPopup(): void
	{
		$this->template->showModal = true;
		$this->redrawControl('modal');
	}

	protected function createComponentCartAddForm(): Multiplier
	{
		return new Multiplier(function($productId): CartAddForm {
			$control = $this->cartAddFormFactory->create();
			$control->setProduct($this->product->variants[$productId]);

			return $control;
		});
	}
}
