<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopCatalog\Model\Entities\Availability;
use EshopCatalog\FrontModule\Model\Dao;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;

class AvailabilityService extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = Availability::class;

	const CACHE_NAMESPACE = 'eshopCatalogAvailability';

	/** @var Cache */
	protected $cache;

	/** @var array */
	protected $cacheDep = [
		Cache::EXPIRE => '1 week',
	];

	public function __construct(IStorage $storage)
	{
		$this->cache = new Cache($storage, self::CACHE_NAMESPACE);
	}

	/**
	 * @return Dao\Availability[]
	 */
	public function getAll(): array
	{
		return $this->cache->load('availabilities/' . $this->translator->getLocale(), function(&$dep) {
			$dep = $this->cacheDep;

			$arr = [];
			foreach ($this->getEr()->createQueryBuilder('a')
				         ->select('a.id, a.ident, at.name, at.description, a.delay, a.color as textColor, a.bgColor, a.canShowOnList, a.canShowOnSearch, a.canAddToCart')
				         ->innerJoin('a.texts', 'at', 'WITH', 'at.lang = :lang')
				         ->setParameter('lang', $this->translator->getLocale())
				         ->getQuery()->getArrayResult() as $row) {
				$arr[$row['id']] = $this->fillDao($row);
			}

			return $arr;
		});
	}

	public function getByIdent(string $ident): ?Dao\Availability
	{
		foreach ($this->getAll() as $item)
			if ($item->getIdent() === $ident)
				return $item;

		return null;
	}

	public function get(int $id): ?Dao\Availability
	{
		return $this->getAll()[$id] ?? null;
	}

	public function fillDao(array $data): Dao\Availability
	{
		$dao = new Dao\Availability();
		$dao->setData($data);

		return $dao;
	}
}
