<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Core\Model\Helpers\DaoHelper;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\Seller;
use EshopCatalog\FrontModule\Model\Dao;
use Doctrine\ORM\Query\Expr\Join;
class Sellers extends BaseFrontEntityService
{
	protected $entityClass = Seller::class;

	/** @var array */
	protected $cSellersForSite = [];

	public function getSellerForSite(string $siteIdent)
	{
		if (!isset($this->cSellersForSite[$siteIdent])) {
			$this->cSellersForSite[$siteIdent] = false;

			$seller = $this->getEr()->createQueryBuilder('s')
					->addSelect('bank')
					->innerJoin('s.sites', 'sites', Join::WITH, 'sites.site = :site')
					->leftJoin('s.bankAccounts', 'bank')
					->setParameter('site', $siteIdent)
					->getQuery()->setMaxResults(1)->getArrayResult()[0] ?? null;

			if ($seller) {
				$seller['bankAccount'] = $seller['bankAccounts'][0] ?? null;
				unset($seller['bankAccounts']);
				$this->cSellersForSite[$siteIdent] = $this->fillDao($seller);
			} else {
				$this->cSellersForSite[$siteIdent] = $this->fillDao(Config::load('seller'));
			}
		}

		return $this->cSellersForSite[$siteIdent] ?: null;
	}

	protected function fillDao(array $data): Dao\Seller
	{
		$dao         = new Dao\Seller();
		$bankAccount = new Dao\BankAccount();

		if ($data['bankAccount']) {
			$bankAccount = DaoHelper::fillDaoFromArray($data['bankAccount'], $bankAccount);
			unset($data['bankAccount']);
		}

		/** @var Dao\Seller $dao */
		$dao = DaoHelper::fillDaoFromArray($data, $dao);
		if ($data['address'])
			$dao->street = $data['address'];
		$dao->setBankAccount($bankAccount);

		return $dao;
	}
}
