<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Helpers\ExportEnums;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="eshop_catalog__category_export")
 * @ORM\Entity
 */
class CategoryExport
{

	/**
	 * @var Category
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public $id;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=false)
	 */
	public $lang;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="service", type="string", nullable=false)
	 */
	public $service;

	/**
	 * @var int
	 * @ORM\Column(name="status", type="smallint", options={"default": 2})
	 */
	public $status;

	/**
	 * @var string
	 * @ORM\Column(name="category_text", type="string", nullable=true)
	 */
	public $categoryText;

	public function __construct(Category $id, string $lang, string $service)
	{
		$this->id   = $id;
		$this->lang = $lang;
		$this->setService($service);
	}

	public function setService(string $service): self
	{
		if (ExportEnums::validateService($service))
			$this->service = $service;

		return $this;
	}
}

