<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="eshop_catalog__product_variant")
 * @ORM\Entity
 */
class ProductVariant
{
	/**
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\Column(name="variant_id", type="integer", nullable=false, options={"unsigned": true})
	 */
	protected int $variantId;

	/**
	 * @ORM\Column(name="is_default", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $isDefault;

	/**
	 * @ORM\Column(name="use_name", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useName;

	/**
	 * @ORM\Column(name="use_name2", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useName2;

	/**
	 * @ORM\Column(name="use_price", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $usePrice;

	/**
	 * @ORM\Column(name="use_retail_price", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useRetailPrice;

	/**
	 * @ORM\Column(name="use_short_description", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useShortDescription;

	/**
	 * @ORM\Column(name="use_description", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useDescription;

	/**
	 * @ORM\Column(name="use_price_levels", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $usePriceLevels;

	/**
	 * @ORM\Column(name="use_unlimited_quantity", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useUnlimitedQuantity;

	/**
	 * @ORM\Column(name="use_discount_disabled", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useDiscountDisabled;

	/**
	 * @ORM\Column(name="use_category_gifts_allowed", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useCategoryGiftsAllowed;

	/**
	 * @ORM\Column(name="use_gifts", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useGifts;

	/**
	 * @ORM\Column(name="use_export", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useExport;

	/**
	 * @ORM\Column(name="use_labels", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useLabels;

	/**
	 * @ORM\Column(name="use_import_price", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useImportPrice;

	/**
	 * @ORM\Column(name="default_image", type="integer", nullable=true, options={"unsigned": true})
	 */
	public ?int $defaultImage = null;

	/**
	 * @var DateTimeInterface
	 * @ORM\Column(name="created_default", type="datetime")
	 */
	public DateTimeInterface $createdDefault;

	public function __construct(Product $product, int $variantId)
	{
		$this->product   = $product;
		$this->variantId = $variantId;

		$this->isDefault               = 0;
		$this->useName                 = 0;
		$this->useName2                = 0;
		$this->usePrice                = 0;
		$this->useRetailPrice          = 0;
		$this->useShortDescription     = 0;
		$this->useDescription          = 0;
		$this->usePriceLevels          = 0;
		$this->useUnlimitedQuantity    = 0;
		$this->useDiscountDisabled     = 0;
		$this->useCategoryGiftsAllowed = 0;
		$this->useGifts                = 0;
		$this->useExport               = 0;
		$this->useLabels               = 0;
		$this->useImportPrice          = 0;

		$this->createdDefault = new DateTime();
	}

	public function getProduct(): Product { return $this->product; }

	public function getVariantId(): int { return $this->variantId; }
}
