<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__seller_bank_account")
 */
class SellerBankAccount
{
	use TId;

	/**
	 * @var Seller
	 * @ORM\ManyToOne(targetEntity="Seller", inversedBy="bankAccounts")
	 * @ORM\JoinColumn(name="seller_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	private $seller;

	/**
	 * @var string
	 * @ORM\Column(name="bank_name", type="string", nullable=true)
	 */
	public $bankName;

	/**
	 * @var string
	 * @ORM\Column(name="number_part1", type="string", nullable=true)
	 */
	public $numberPart1;

	/**
	 * @var string
	 * @ORM\Column(name="number_part2", type="string", nullable=true)
	 */
	public $numberPart2;

	/**
	 * @var string
	 * @ORM\Column(name="swift", type="string", nullable=true)
	 */
	public $swift;

	/**
	 * @var string
	 * @ORM\Column(name="iban", type="string", nullable=true)
	 */
	public $iban;

	public function __construct(Seller $seller)
	{
		$this->seller  = $seller;
	}

	public function getSeller(): Seller { return $this->seller; }
}
