<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__seller_in_site")
 */
class SellerInSite
{
	use TId;

	/**
	 * @var Seller
	 * @ORM\ManyToOne(targetEntity="Seller", inversedBy="sites")
	 * @ORM\JoinColumn(name="seller_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	private $seller;

	/**
	 * @var Site
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", nullable=false, onDelete="CASCADE")
	 */
	private $site;

	/**
	 * @var int
	 * @ORM\Column(name="in_stock", type="smallint", length=1, options={"default"=1})
	 */
	public $isActive;

	public function __construct(Seller $seller, Site $site)
	{
		$this->seller   = $seller;
		$this->site     = $site;
		$this->isActive = 1;
	}

	public function getSeller(): Seller { return $this->seller; }

	public function getSite(): Site { return $this->site; }
}
