<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\Model\Navigation\Home;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Localization\ITranslator;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;
use Slides\FrontModule\Model\Slides;
use Slides\Model\Entities\Slide;

class TagTextListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var Cache */
	protected $cache;

	/** @var ITranslator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, ITranslator $translator)
	{
		//		$this->cache           = new Cache($cacheStorage, Products::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param ProductTexts       $productText
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($productText, $args)
	{
		//		$this->cache->clean([
		//			Cache::TAGS => [
		//				'product/' . $productText->getProduct()->getId(),
		//			],
		//		]);
		//
		//		$this->navigationCache->clean([
		//			Cache::TAGS => [
		//				Home::CACHE_PRODUCT . '/' . $productText->getProduct()->getId(),
		//			],
		//		]);
	}
}
