<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Subscribers;

use Core\Model\Sites;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Core\Model\Event\TemplateFactoryEvent;
use EshopCatalog\FrontModule\Model\Sellers;

class TemplateFactorySubscriber implements EventSubscriberInterface
{
	protected Sellers $sellersService;

	protected Sites $sites;

	public function __construct(Sellers $sellers, Sites $sites)
	{
		$this->sellersService = $sellers;
		$this->sites = $sites;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => 'createTemplate',
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->seller = $this->sellersService->getSellerForSite($this->sites->getCurrentSite()->getIdent());
	}
}
