<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Model\UI\BaseControl;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Products;

class ProductPreview extends BaseControl
{
	/** @var Products */
	protected $productsService;

	/** @var ICartAddFormFactory */
	protected $cartAddFormFactory;

	/** @var Product */
	protected $product;

	/** @var string */
	public $templateFileName = 'ProductPreview';

	public function __construct(Products $products, ICartAddFormFactory $cartAddForm)
	{
		$this->productsService    = $products;
		$this->cartAddFormFactory = $cartAddForm;
	}

	public function render()
	{
		$this->template->product = $this->product;
		$this->template->render($this->getTemplateFile($this->templateFileName, 'ProductPreview'));
	}

	public function createComponentCartAddForm(): CartAddForm
	{
		$control = $this->cartAddFormFactory->create();
		$control->setProduct($this->product);

		return $control;
	}

	public function setProduct(Product $product): void
	{
		$this->product = $product;
	}

	public function setProductById(int $id): void
	{
		$this->product = $this->productsService->get($id, ['loadPrice' => true]);
	}
}
