<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Event;

use EshopCatalog\FrontModule\Model\Dao\Category;
use Symfony\Component\EventDispatcher\Event;

class CategoryHeadEvent extends Event
{
	/** @var string */
	public $title;

	/** @var string */
	public $categoryName;

	/** @var string */
	public $description;

	/** @var array */
	public $activeFilters;

	/** @var Category */
	public $category;

	public function __construct(string &$title, string &$categoryName, string &$description, array $activeFilters, Category $category)
	{
		$this->title         = &$title;
		$this->categoryName  = &$categoryName;
		$this->description   = &$description;
		$this->activeFilters = $activeFilters;
		$this->category      = $category;
	}
}
