<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__feature_product")
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureProductListener"})
 */
class FeatureProduct
{
	use MagicAccessors;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="FeatureProduct", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $product;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Feature", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_feature", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $feature;

	/**
	 * @ORM\ManyToOne(targetEntity="FeatureValue", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_feature_value", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $featureValue;

	public function __construct(Product $product, Feature $feature, FeatureValue $featureValue)
	{
		$this->product      = $product;
		$this->feature      = $feature;
		$this->featureValue = $featureValue;
	}

	public function getFeature()
	{
		return $this->feature;
	}

	public function getFeatureValue()
	{
		return $this->featureValue;
	}

	public function getIdProduct()
	{
		return $this->product->getId();
	}

	public function getIdFeature()
	{
		return $this->feature->getId();
	}

	public function getIdFeatureValue()
	{
		return $this->featureValue->getId();
	}

	public function setFeature(Feature $feature)
	{
		$this->feature = $feature;
	}

	public function setFeatureValue(FeatureValue $featureValue)
	{
		return $this->featureValue = $featureValue;
	}
}
